﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
/// Summary description for clsCompression
/// </summary>
public class clsCompression
{

    public List<Byte> RLEUncompress(List<Byte> RLEBytes)
    {
        List<Byte> SomeBytes = new List<Byte>();
        Int32 Counter = 0;
        Int32 MSB = 0;
        Int32 LSB = 0;
        Int32 RunLength = 0;
        Int32 RunCounter=0;
        Byte RunByte=0;
        while (Counter < RLEBytes.Count)
        {
            RunByte = RLEBytes[Counter];
            MSB = RLEBytes[Counter+1];
            LSB = RLEBytes[Counter + 2];
            RunLength = MSB * 256 + LSB;
            RunCounter = 0;
            while (RunCounter < RunLength)
            {
                SomeBytes.Add(RunByte);
                RunCounter++;
            }
            Counter+=3;
        }
        return SomeBytes;
    }

    public List<Byte> RLECompress(List<Byte> SomeBytes)
    {
        List<Byte> RLEBytes = new List<Byte>();
        List<Byte> TempBytes = new List<Byte>();
        Byte SomeData;
        Byte NextByte;
        Int32 ByteCount = 1;
        Int32 Count = 0;
        if (SomeBytes.Count > 0)
        {
            ByteCount = 1;
            Count = 0;
            SomeData = SomeBytes[Count];
            while (Count < SomeBytes.Count - 1)
            {
                //examine next byte
                NextByte = SomeBytes[Count + 1];
                if (SomeData == NextByte)
                {
                    ByteCount++;
                }
                else if (SomeData != SomeBytes[Count + 1])
                {
                    RLEBytes.Add(SomeData);// = AddBytePair(RLEBytes,SomeData);
                    RLEBytes = AddBytePair(RLEBytes, ByteCount);
                    ByteCount = 1;
                }
                if (Count < SomeBytes.Count - 2)
                {
                    SomeData = NextByte;
                }
                else
                {
                    if (NextByte == SomeData)
                    {
                        RLEBytes.Add(SomeData);// = AddBytePair(RLEBytes, SomeData);
                        RLEBytes = AddBytePair(RLEBytes, ByteCount);
                    }
                    else
                    {
                        RLEBytes.Add(NextByte);// = AddBytePair(RLEBytes, NextByte);
                        RLEBytes = AddBytePair(RLEBytes, 1);
                    }
                }
                Count++;
            }
        }
        return RLEBytes;
    }

    private List<Byte> AddBytePair(List<Byte> SomeBytes, Int32 SomeData)
    {
        clsBaseConvert Base = new clsBaseConvert();
        List<Byte> TempBytes = new List<Byte>();
        TempBytes = Base.GetDecBytes(SomeData,2);
        SomeBytes.Add(TempBytes[0]);
        SomeBytes.Add(TempBytes[1]);
        return SomeBytes;
    }


    public List<Byte> LZWUncompress(List<Byte> LZWData)
    {
        string SomeString;
        List<Byte> SomeBytes = new List<byte>();
        SomeString = Bytes2HexString(LZWData);
        SomeString = LZWUncomp(SomeString);
        SomeBytes = String2Bytes(SomeString);
        return SomeBytes;
    }

    public List<Byte> LZWCompress(List<Byte> SomeBytes)
    {
        List<Byte> LZWData = new List<byte>();
        string SomeString;
        SomeString = Bytes2String(SomeBytes);
        SomeString = LZWComp(SomeString);
        LZWData = HEXString2Bytes(SomeString);
        
        return LZWData;
    }

    private string Bytes2HexString(List<Byte> SomeBytes)
    {
        clsBaseConvert Hex = new clsBaseConvert();
        string SomeString="";
        string SomeHEX;
        for (Int32 Counter = 0; Counter < SomeBytes.Count; Counter ++)
        {
            byte SomeByte;
            SomeByte = SomeBytes[Counter];
            SomeHEX = Hex.DecToHex(SomeByte);
            SomeString = SomeString + SomeHEX;
        }
        return SomeString;
    }


    private List<Byte> HEXString2Bytes(string SomeString)
    {
        clsBaseConvert Hex = new clsBaseConvert();
        List<Byte> LZWData = new List<byte>();
        for (Int32 Counter = 0; Counter < SomeString.Length; Counter+=2)
        {
            byte SomeByte;
            Int32 temp = SomeString.Length;
            SomeByte =Convert.ToByte(Hex.HexToDec(SomeString.Substring(Counter, 2)));
            LZWData.Add(SomeByte);
        }
        return LZWData;
    }

    private string Bytes2String(List<Byte> SomeBytes)
    {
        string SomeString="";
        for (Int32 Counter = 0; Counter < SomeBytes.Count; Counter++)
        {
            char SomeChar;
            SomeChar = (char)SomeBytes[Counter];
            SomeString = SomeString + SomeChar.ToString();
        }
        return SomeString;
    }

    private List<Byte> String2Bytes(string SomeString)
    {
        List<Byte> SomeBytes = new List<Byte>();
        for (Int32 Counter = 0; Counter < SomeString.Length; Counter++)
        {
            Byte SomeByte;
            char SubStr;
            SubStr =Convert.ToChar( SomeString.Substring(Counter, 1));
            SomeByte = (Byte)SubStr;
            SomeBytes.Add(SomeByte);
        }
        return SomeBytes;
    }

    private string LZWUncomp(string data)
    {
        List<string> dictionary = BuildDictionary();
        Int32 Counter = 0;
        string OriginalData = "";
        //string entry;
        string entry="";
        //char ch;
        string ch;
        string NewEntry = "";
        //int prevcode, currcode;
        Int32 prevcode;
        Int32 currcode;
        //prevcode = read in a code;
        prevcode = GetCode(data, Counter);
        Int32 temp = data.Length;
        Counter += 4;
        //decode/output prevcode;
        OriginalData = dictionary[prevcode];
        entry = OriginalData;
        //while (there is still data to read)
        while (Counter < data.Length - 3)
        {
            //    currcode = read in a code;
            currcode = GetCode(data, Counter);
            //entry = translation of currcode from dictionary;
            if (currcode < dictionary.Count)
            {
                entry = dictionary[currcode];
            }
            else
            {
                entry = entry + entry.Substring(0, 1);
            }
            //you simply take the substring you have so far, "ab", and concatenate its first character to itself, "ab"+"a" = "aba",
            //    output entry;
            OriginalData += entry;
            //    ch = first char of entry;
            ch = entry.Substring(0, 1);
            //    add ((translation of prevcode)+ch) to dictionary;
            NewEntry = dictionary[prevcode] + ch;
            dictionary.Add(NewEntry);
            //    prevcode = currcode;
            prevcode = currcode;
            Counter += 4;
        }
        return OriginalData;
    }

    private Int32 GetCode(string Data, Int32 Posn)
    {
        clsBaseConvert Hex = new clsBaseConvert();
        Int32 ACode;
        string Bits12;
        //prevcode = read in a code;
        Bits12 = Data.Substring(Posn, 4);
        ACode = Hex.HexToDec(Bits12);
        return ACode;
    }
    
    private string LZWComp(string data)
    {
        List<string> dictionary = BuildDictionary();
        //var to store data to look up in the dictionary
        string ToLookUp;
        //var to store the final compressed output
        string CompressedOutput = "";
        //var to store data from last run of loop
        string PreviousData;
        //var to store a single character from the data to be compressed
        string SingleCharacter = "";
        Int32 temp;
        //counter for the loop marking position in data for compression
        Int32 Counter = 0;
        //initialise previous data to blank string (as loop hasn't run yet)
        PreviousData = "";
        //while there is still data to be read
        while (Counter < data.Length)
        {
            //get the next character at position counter
            SingleCharacter = data.Substring(Counter, 1);
            //look up data is last data + this new character
            ToLookUp = PreviousData + SingleCharacter;
            //if the dictionary already contains the character to look up
            if (dictionary.Contains(ToLookUp))
            {
                //save the data for the next run of the loop
                PreviousData = ToLookUp;
            }
            else
            {
                //get the index of the previous data
                temp = dictionary.IndexOf(PreviousData);
                //get the index of the previous data and add it to the compressed output
                CompressedOutput += Get12Bits(temp);
                //add the data to look up to the dictionary
                dictionary.Add(ToLookUp);
                //set the previous data to the one character we read this time
                PreviousData = SingleCharacter;
            }
            //increment the counter
            Counter++;
        }
        //process the final item of previous data
        temp = dictionary.IndexOf(PreviousData);
        //get the index of the previous data and add it to the compressed output
        CompressedOutput += Get12Bits(temp);
        //return the compressed output
        return CompressedOutput;
    }

    private string Get12Bits(Int32 Index)
    {
        clsBaseConvert Hex = new clsBaseConvert();
        //temp array list to store the bytes
        List<byte> Bytes = new List<byte>();
        string Bits12 = "";
        //get the two bytes for this data
        Bytes = Hex.GetDecBytes(Index, 2);
        //concatenate the bytes
        Bits12 = Hex.DecToHex(Bytes[0]) + Hex.DecToHex(Bytes[1]);
        //chop it down to 12 bits
        Bits12 = Bits12.Substring(0);
        return Bits12;
    }

    private List<string> BuildDictionary()
    {
        List<string> dictionary = new List<string>();
        //dictionary.Add("a");
        //dictionary.Add("b");
        dictionary.Clear();
        for (Int32 Counter = 0; Counter < 256; Counter++)
        {
            char c = (char)Counter;
            dictionary.Add(c.ToString());
        }
        return dictionary;
    }
}